package gov.va.med.mhv.bluebutton.repository;

import gov.va.med.mhv.bluebutton.model.PhrRadiology;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PhrRadiologyRepository extends JpaRepository<PhrRadiology, Long> {
	
	@Query("select s from PhrRadiology s where s.patientId = :patientId")
	List<PhrRadiology> findByPatientId(@Param("patientId") Long patientId);
	
	@Query("select s from PhrRadiology s where s.patientId = :patientId and s.id = :id")
	List<PhrRadiology> findByPatientIdAndPhrRadiologyId(@Param("patientId") Long patientId, @Param("id") Long id);

}
